
// Digital Face - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#include "../neurosis/neurosis.h"
#include "extra.h"

/***************************************************************************/

CNeurosisWindow			gWindow(10.0f, 125.0f);
CNeurosisCamera			gCamera;
CNeurosisController	gController(MOUSE);
CNeurosisModel			gEyeballLeftModel;
CNeurosisModel			gEyeballRightModel;
CNeurosisModel			gFaceModel;
CNeurosisTiming			gTiming;

/***************************************************************************/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)

{
	Initialize_System();
	if (!gWindow.GL_Create_Window("Digital Face", 640, 480, 16, false, false, true, true))
		exit(EXIT_FAILURE);

	Initialize_Textures();
	while (gWindow.mQuit == false)
	{
		gTiming.Update();
		gWindow.Process_Messages();

		if (gWindow.mActive)
		{
			if (gWindow.pKeys[VK_ESCAPE])
				gWindow.mQuit = true;
			else
			{
				Update_Keyboard();
				Update_Mouse();
				Draw_Scene();
				SwapBuffers(gWindow.hDC);
			}
		}
	}

	// Shutdown
	return ((int)(gWindow.mMsg.wParam));
}

/***************************************************************************/